'**************************
'18M2 RCD Trip Tester
'PJW Jan 2013
'**************************
'Clock speed
Setfreq M32
'Variables
symbol outbyte = b0
symbol rs = b1 ' bit 0 of port expander
symbol counter = b2 '
symbol nblcount = b3
symbol messageflag = b4 ' Message number to display
symbol StartAngle = b5 ' 0 or 180 degrees
symbol timemode = b6 ' 0,1 = time, 1,2 = cycles
symbol ok = b7 'Pass fail
'symbol spare = w5
symbol temp = W6
symbol values = w7 'data to be displayed
'Constants
symbol dataout = b.4 'lCD RS port
symbol latchout =b.5 'LCD latch/Clock port
symbol lcddata =1
symbol lcdinst =0
symbol Line1 = $80
symbol Line2 =$C0
symbol Supplyon = c.5
symbol Trigger = c.7
symbol PBStart = pinc.0
symbol Optoout = c.2
'************************
'Initialise LCD
Initialiselcd:
rs = lcdinst
for counter = 0 to 5
	lookup counter, ($33,$32,$28,$0C,$01,$06),outbyte
	gosub lcdout
next counter
'*************************
'Initialise Message
gosub display1stline
'*************************
'Main Loop
main:
	'Wait til start button
	if PBStart = 1 then 'Start
		if startangle = 0 then
			messageflag = 2
		else
			messageflag = 3
		end if
		gosub display1stline
		gosub starttest
	end if
goto main

'*************************
'Start at zero crossing
starttest:
	do ' wait for end of half cycle
		if pinc.7 = 0 then ' exit only if in negative half cycle
			exit 
		end if
	loop
	do 'wait for start of positive half cycle zero crossing
		if pinc.7 = 1 then ' exit only at start of positive half cycle
			exit 
		end if
	loop
	if startangle = 0 then 'wait for rising waveform
		pause 80  ' 10 milliseconds at 32MHz - wait one half cycle
	end if
	'Time the trip
	high c.2  ' Turn on Optocoupler LED
	high b.6  ' Turn on LED
	select case timemode
		case 0,1 '
			do ' simply count loops
				values = values +1
				if values >10000 then
					values = 0
					exit
				end if
			loop until pinc.5 = 1
		case 2,3
			count c.7, 8000,values' 1 second
	end select
	low c.2 ' Opto off
	low b.6 'LED off
	select case timemode
		case 0,1
			values = values /10
			values = values * 38 'Calibration factor
			values = values /10
		
		else
	end select
	select case values
		case 0, 50
			messageflag = 1
			gosub display1stline
		else
			gosub display2ndline	
	end select
	pause 20000 
	if startangle= 0 then ' change start angle for next test
		startangle = 180
	else
		startangle = 0
	end if
	timemode = timemode +1
	if timemode >3 then
		timemode = 0
	end if
	messageflag = 0
	gosub display1stline
	values = 0
	gosub display2ndline
	
return
'********************
'LCD Display routine
lcdout:
for nblcount = 1 to 2
	high b.5'latchout ' set latch high
	select case RS
		case = 1 ' data
			high b.4'dataout
		case = 0 ' instr
			low b.4'  dataout
	end select
	temp = outbyte & 16
	if temp = 16 then ' bit 4
		high b.0
	else
		low b.0
	end if
	temp = outbyte & 32 ' bit 5
	if temp = 32 then
		high b.1
	else
		low b.1
	end if
	temp = outbyte & 64 ' bit 6
	if temp = 64 then
		high b.2
	else
		low b.2
	end if
	temp = outbyte & 128 ' bit 7
	if temp = 128 then
		high b.3
	else
		low b.3
	end if
	low b.5'latchout ' Clock the display
	pause 4
	outbyte = outbyte *16  'Shift outbyte Left to get next nibble
	next nblcount
return

'*******************
Display1stline:
	'display message
	rs = lcdinst
	outbyte = $80  ' First Line
	gosub lcdout
	rs = lcddata
	for counter = 0 to 15
		select case messageflag
			case 0 
			 	lookup counter ,  ("Waiting to Start"), outbyte
			case 1
				lookup counter ,  ("Trip Failure:   "), outbyte
			case 2 
			 	lookup counter ,  ("Testing: 0 Deg  "), outbyte
			case 3 
			 	lookup counter ,  ("Testing: 180 Deg"), outbyte
		end select
		gosub lcdout
	next counter
return
'********************
Display2ndline:
	'Display data
	rs = lcdinst  'Second Line
	outbyte = $C0
	gosub lcdout
	rs = lcddata
	if values = 0 then ' clear line
		for counter = 1 to 15
			outbyte = 32
			gosub lcdout
		next counter
	else ' display data
		for counter = 1 to 8   
			select case counter
				case 1
					temp = values/10000  ' 10000's
				case 2
					temp = values/1000  '1000's
					temp = temp//10
				case 3
					temp = values/100  '100's
					temp = temp //10
				case 4
					temp = values/10   '10's
					temp = temp//10
				case 5
					temp = values//10  ' 1's
				case 6
					temp = 32 - $30  'space
				case 7
					if timemode <=1 then
						temp = 109 - $30 'm
					else
						temp = 99 - $30 'c
					end if
				case 8
					if timemode <=1 then
						temp = 115 - $30 's
					else
						temp = 121 - $30 'c
					end if

			end select
			outbyte = temp + $30
			gosub lcdout
		next counter
		gosub passfail
	end if
return
'****************************
passfail:
	rs = lcddata
	select case timemode
		case 0,1
			If values <=300 then
			Ok = 1
			else
			ok = 0
			end if
		case 1,2
			if values <=15 then 
				oK = 1
			else
				ok = 0
			end if
	end select
	for counter = 0 to 6
		select case OK
			case 0 
			 	lookup counter ,  (" - Fail"), outbyte
			case 1
				lookup counter ,  (" - Pass"), outbyte
		end select
		gosub lcdout
	next counter
return






